﻿/// <reference path="OrderEntry.aspx" />

function ManagerLogin()
{
    var userName = $get("LoginUserName").value
    var password = $get("LoginPassword").value
    var linkButtonText = $get("LinkButtonManagerEnable").innerHTML;
    Sys.Services.AuthenticationService.login(userName,password,false,null,null,onSuccessManagerLogin,onFailed,linkButtonText);
    ResetLogin();
}

function onSuccessManagerLogin(result, userContext, methodName )
{
    if(result == true)
    {
        GetRoles(userContext);
    }
}

function GetRoles(callingContext)
{
   Sys.Services.RoleService.load(onSuccessGetRoles,onFailed,callingContext);
}

function onSuccessGetRoles(result, userContext, methodName )
{
    if(userContext == "Enable")
    {
        if(Sys.Services.RoleService.isUserInRole("Manager"))
        {
            EnableOverrideSection();
        }
        else
        {
            alert("Użytkownik nie dysponuje uprawnieniami menedżera");
        }
    }
    else
    {
        DisableOverrideSection();
    }
}


function EnableOverrideSection()
{
    $get(DropDownListDiscountID).disabled = "";
    $get(LinkButtonManagerEnableID).innerHTML = "Disable";

}

function DisableOverrideSection()
{
    $get(DropDownListDiscountID).disabled = "disabled";
    $get(LinkButtonManagerEnableID).innerHTML = "Enable";
    
}

function ResetLogin()
{
    $get("LoginUserName").value = "";
    $get("LoginPassword").value = "";
}

function onFailed(result, userContext, methodName)
{
  alert("Wystąpił błąd \n"  + result.get_message());
}
